<?php
    // Social icons footer
    $multicote_wp_bottom_social_icons = get_theme_mod('multicote_wp_bottom_social_icons');       
    $multicote_wp_bottomicons_display = get_theme_mod('multicote_wp_bottomicons_display');
    if (empty($multicote_wp_bottomicons_display)) { $multicote_wp_bottomicons_display = 'No'; }

    // Copyright
    $multicote_wp_copyright = get_theme_mod('multicote_wp_copyright'); 
?>

<!-- footer social icons. -->
<?php if ($multicote_wp_bottomicons_display == 'Yes') { ?>
    <div class="clear"></div>
    <div class="waveHorizontals">
        <div id="waveHorizontal1" class="waveHorizontal"></div>
        <div id="waveHorizontal2" class="waveHorizontal"></div>
        <div id="waveHorizontal3" class="waveHorizontal"></div>
    </div><!-- end .waveHorizontals -->
    <div class="social-section">
        <?php if (!empty($multicote_wp_bottom_social_icons)) { ?><?php echo wp_kses_post(stripslashes($multicote_wp_bottom_social_icons)); ?><?php } ?>
    </div><!-- end .social-section -->
<?php } ?>

<!-- Begin Footer -->
<footer> 
	<div class="wrap-footer">
      <!-- Begin random articles on slide -->
      <div class="featured-articles">

        <div class="featured-title">
            <h3><?php esc_html_e('Random Articles', 'multicote-wp'); ?></h3>
            <div class="slide-nav">
              <span id="slider-prev2"></span>
              <span id="slider-next2"></span>
            </div><!-- end .slide-nav -->          
        </div><!-- end .featured-title --> 
               
        <ul class="random-articles-slider">
        <?php $multicote_wp_randomposts = new WP_Query(array('orderby' => 'rand', 'posts_per_page' => 12 )); // number to display more / less ?>
        <?php while ($multicote_wp_randomposts->have_posts()) : $multicote_wp_randomposts->the_post(); ?> 

            <li <?php post_class('post-slide') ?>>
                    <div class="article-category"><i></i> <?php $category = get_the_category(); if ($category) 
                        { echo '<a href="' . get_category_link( $category[0]->term_id ) . '" class="tiptipBlog" title="' . sprintf( esc_html__( "View all posts in %s", "multicote-wp" ), $category[0]->name ) . '" ' . '>' . $category[0]->name.'</a> ';}  ?>
                    </div><!-- end .article-category -->                
                <?php if ( has_post_thumbnail()) { ?>
                    <?php the_post_thumbnail('multicote-wp-thumbnail-blog-featured', array('title' => "")); ?>
                <?php } else { ?> 
                    <a href="<?php the_permalink(); ?>"><img src="<?php echo get_template_directory_uri(); ?>/images/no-img.png" alt="<?php esc_html_e('article image', 'multicote-wp'); ?>" /></a> 
                <?php } // Post Thumbnail ?> 


                <div class="title-box">
                    <span><?php the_author_posts_link(); ?></span>
                    <?php if(function_exists('taqyeem_get_score')) { ?> <?php taqyeem_get_score(); ?> <?php } ?>                    
                    <div class="clear"></div>
                    <h2><a href="<?php the_permalink(); ?>"><?php if ( strlen(get_the_title()) > 60 ) { echo mb_substr(get_the_title(), 0, 56)." ..."; } else { the_title(''); } ?></a></h2>
                </div>

            </li><!-- end .post-slide --> 
        <?php endwhile; 
        /* Restore original Post Data */
        wp_reset_postdata(); ?>
        </ul><!-- end .random-articles-slider -->        
      </div> <div class="clear"></div> <!-- end .featured-articles -->


        <div class="one_fourth">
            <?php if ( is_active_sidebar( 'multicote_wp_footer1' ) ) { ?>
                <?php dynamic_sidebar( 'multicote_wp_footer1' ); ?><!-- #1st footer -->
            <?php } ?>
        </div>
        <div class="one_fourth">
            <?php if ( is_active_sidebar( 'multicote_wp_footer2' ) ) { ?>
                <?php dynamic_sidebar( 'multicote_wp_footer2' ); ?><!-- #2nd footer -->
            <?php } ?>
        </div>
        <div class="one_fourth">
            <?php if ( is_active_sidebar( 'multicote_wp_footer3' ) ) { ?>
                <?php dynamic_sidebar( 'multicote_wp_footer3' ); ?><!-- #3rd footer -->
            <?php } ?>
        </div>
        <div class="one_fourth_last">
            <?php if ( is_active_sidebar( 'multicote_wp_footer4' ) ) { ?>
                <?php dynamic_sidebar( 'multicote_wp_footer4' ); ?><!-- #4th footer -->
            <?php } ?>
        </div><div class="clear"></div>        
 

        <div class="copyright">
            <?php if (!empty($multicote_wp_copyright)) { ?>
              <?php echo wp_kses_post(stripslashes($multicote_wp_copyright)); ?>
            <?php } else { ?>
              <?php esc_html_e( 'The multicote is your Review Magazine Blog News WordPress Theme', 'multicote-wp' ); ?><br />
              <?php esc_html_e( 'Go to Theme Options > Footer Settings and add your Copyright text!', 'multicote-wp' ); ?>
            <?php } ?>
        </div>
    </div>
	<p id="back-top"><a href="#top"><span></span></a></p>
</footer><!-- end #footer -->


<!-- Footer Theme output -->
<?php wp_footer();?>
</body>
</html>